/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19; import djbuch.kapitel_06.GC; import lotus.domino.*;
/**
 * Stellt hufig bentigte Domino Objekte fr einen 
 * Test bereit.
 * @author Thomas Ekert
 *
 */
public class NotesTestObjects {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de:63148"; //null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH"; //null fr lokale Session
	private static final String TESTDATABASE = "djbuch/djbuch.nsf";
	private static final String TESTSERVER = "Java/DJBUCH";
	private static final String TESTFORM = "FO_Test_k19";
	private static final int NOTESEXCEPTION_NO = 999;
	
	/**
	 * Gibt eine vordefinierte Testdatenbank zurck
	 * @return geffnete Test Datenbank
	 * @throws NotesException
	 */
	public Database getDb() throws NotesException {
		if (testDb == null) {
			testDb = getSession().getDatabase(TESTSERVER, TESTDATABASE);
		}
		if (testDb == null || !testDb.isOpen()) {
			throw new NotesException(NOTESEXCEPTION_NO,
					"Die Testdatenbank wurde nicht gefunden oder geffnet.");
		}
		return testDb;
	}

	/**
	 * Erzeugt ein Kontext Dokument, falls noch keines existiert.
	 * @return - not Null
	 * @throws NotesException
	 */
	public Document getDocumentContext () throws NotesException {
		if (docContext == null) {
			docContext = getDb().createDocument();
			docContext.replaceItemValue("Form", TESTFORM);
			docContext.save(true,false);
		}
		if (docContext == null) {
			throw new NotesException(NOTESEXCEPTION_NO,
			"Das Kontext Document konnte nicht erzeugt werden.");			
		}
		return docContext;
	}
	
	/**
	 * Gibt die Session zurck, ber die der Server erreichbar ist.
	 * @return notnull
	 * @throws NotesException
	 */
	public Session getSession() throws NotesException {
		if (session == null) {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
		}
		if (session == null) {
			throw new NotesException(NOTESEXCEPTION_NO,
					"Die Session konnte nicht erzeugt werden.");
		}
		return session;
	}

	/**
	 * lscht (!) das Kontext Document, falls vorhanden
	 * und recycled alle internen Domino Objekte
	 */
	public void recycle() {
		if (docContext != null) {
			try {
				docContext.remove(true);
				docContext = GC.recycle (docContext);
			} catch (NotesException e) {
				e.printStackTrace();
			}
		}
		testDb = GC.recycle(testDb);
		session = GC.recycle(session);
	}

	private Session session = null;
	private Database testDb = null;
	private Document docContext = null;
}